within ;
model SD1_Dymola_CS
  Modelica.Mechanics.Rotational.Components.Spring spring(c=1)
    annotation (Placement(transformation(extent={{30,-10},{50,10}})));
  Modelica.Mechanics.Rotational.Components.Damper damper(d=1)
    annotation (Placement(transformation(extent={{30,-40},{50,-20}})));
  Modelica.Mechanics.Rotational.Components.Fixed fixed annotation (
      Placement(transformation(
        extent={{-10,-10},{10,10}},
        rotation=90,
        origin={70,0})));
  Modelica.Mechanics.Rotational.Sensors.TorqueSensor torqueSensor
    annotation (Placement(transformation(
        extent={{10,10},{-10,-10}},
        rotation=0,
        origin={-10,0})));
  Modelica.Blocks.Interfaces.RealOutput TqSD
    "Torque in flange flange_a and flange_b (tau = flange_a.tau = -flange_b.tau) as output signal"
    annotation (Placement(transformation(extent={{-100,30},{-120,50}})));
  Modelica.Mechanics.Rotational.Sources.Speed speed(exact=true)
    annotation (Placement(transformation(extent={{-60,-10},{-40,10}})));
  Modelica.Blocks.Interfaces.RealInput Nj1
    "Reference angular velocity of flange with respect to support as input signal"
    annotation (Placement(transformation(extent={{-120,-50},{-100,-30}})));
equation
  connect(fixed.flange, spring.flange_b)
    annotation (Line(points={{70,0},{50,0}}, color={0,0,0}));
  connect(damper.flange_b, spring.flange_b) annotation (Line(points={{50,
          -30},{60,-30},{60,0},{50,0}}, color={0,0,0}));
  connect(torqueSensor.tau, TqSD) annotation (Line(points={{-2,11},{
          -2,40},{-110,40}},
                          color={0,0,127}));
  connect(damper.flange_a, spring.flange_a) annotation (Line(points={{30,
          -30},{20,-30},{20,0},{30,0}}, color={0,0,0}));
  connect(speed.w_ref, Nj1) annotation (Line(points={{-62,0},{-80,0},{-80,
          -40},{-110,-40}}, color={0,0,127}));
  connect(speed.flange, torqueSensor.flange_b) annotation (Line(
        points={{-40,0},{-30,0},{-30,0},{-20,0}}, color={0,0,0}));
  connect(torqueSensor.flange_a, spring.flange_a)
    annotation (Line(points={{0,0},{30,0}}, color={0,0,0}));
  annotation (Icon(coordinateSystem(preserveAspectRatio=false), graphics={
          Rectangle(
          extent={{-100,100},{100,-100}},
          lineColor={28,108,200},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid), Text(
          extent={{-80,20},{80,-20}},
          lineColor={28,108,200},
          fillColor={255,255,255},
          fillPattern=FillPattern.None,
          textString="SD1")}),       Diagram(coordinateSystem(
          preserveAspectRatio=false)),
    uses(Modelica(version="3.2.2")));
end SD1_Dymola_CS;
